<?php

require_once(dirname(dirname(__FILE__)). '/app.php');

if (!isset($_GET["doacao"])) {
   if (isset($_POST["chave"]) && isset($_POST["beneficiario"]) && isset($_POST["cidade"])) {
      $chave_pix=strtolower($_POST["chave"]);
      $beneficiario_pix=$_POST["beneficiario"];
      $cidade_pix=$_POST["cidade"];
      if (isset($_POST["descricao"])){
         $descricao=$_POST["descricao"];
      }
      else { $descricao=''; }
      if ((!isset($_POST["identificador"])) || (empty($_POST["identificador"]))) {
         $identificador="***";
      }
      else {
         $identificador=$_POST["identificador"];
      }
      $gerar_qrcode=true;
	
   }
   else {
      $cidade_pix="SAO PAULO";
      $gerar_qrcode=false;
   }
}
else {
   $chave_pix="42a57095-84f3-4a42-b9fb-d08935c86f47";
   $beneficiario_pix="RENATO MONTEIRO BATISTA";
   $cidade_pix="NATAL";
   $identificador="***";
   $descricao="Demo phpQRCodePix";
   $gerar_qrcode=true;
}
if (is_numeric($_POST["valor"])){
   $valor_pix=preg_replace("/[^0-9.]/","",$_POST["valor"]);
}
else {
   $valor_pix="0.00";
}

 $link = $ROOTPATH."/pix/pix.php?chave=$chave_pix&beneficiario=$beneficiario_pix&cidade=$cidade_pix&descricao=$descricao&valor=".$_POST["valor"];
  
?>

<!doctype html>
<html lang="pt-br">
<head>
<title>Gerador de QR Code do PIX</title>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">  
<!--
<link href="phpqrcode/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" type="text/css">
<link href="phpqrcode/css/grid.scss" rel="stylesheet" type="text/css" >
<link href="phpqrcode/css/reboot.scss" rel="stylesheet" type="text/css" >
<script src="phpqrcode/js/bootstrap.bundle.min.js" integrity="sha384-ygbV9kiqUc6oa4msXn9868pTtWMgiQaeYH7/t7LECLbyPA2x65Kgf80OJFdroafW" crossorigin="anonymous"></script>
<script src="phpqrcode/js/jquery.min.js" type="text/javascript"></script>
<script src="phpqrcode/js/0f8eed42e7.js" crossorigin="anonymous"></script>
-->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" crossorigin="anonymous">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/js/bootstrap.bundle.min.js" integrity="sha384-ygbV9kiqUc6oa4msXn9868pTtWMgiQaeYH7/t7LECLbyPA2x65Kgf80OJFdroafW" crossorigin="anonymous"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js" type="text/javascript"></script>
<script src="https://kit.fontawesome.com/0f8eed42e7.js" crossorigin="anonymous"></script>
 

<script>
function copiar() {
  var copyText = document.getElementById("brcodepix");
  copyText.select();
  copyText.setSelectionRange(0, 99999); /* For mobile devices */
  document.execCommand("copy");
  document.getElementById("clip_btn").innerHTML='<i class="fas fa-clipboard-check"></i>';
}
function reais(v){
    v=v.replace(/\D/g,"");
    v=v/100;
    v=v.toFixed(2);
    return v;
}
function mascara(o,f){
    v_obj=o;
    v_fun=f;
    setTimeout("execmascara()",1);
}
function execmascara(){
    v_obj.value=v_fun(v_obj.value);
}
$(function () {
  $('[data-toggle="tooltip"]').tooltip()
})

function vercampos()  {

	if( $('#chave').val() ==""){
		alert('')
	}
} 
</script> 

<style>
a {text-decoration: none;} 
p {text-align: center;}


.row>* { 
    width: 49% !important; 
}

.card {
    width: 100% !important;  
}

@media (min-width: 992px){
	.row-cols-lg-auto>* {
		width: 49%  !important;  
	}
}

</style>
</head>
<body style="text-align: center;">
<?php
/*
# Exemplo de uso do php_qrcode_pix com descrição dos campos 
# Desenvolvido em 2021 por Vipcom Sistemas - http://www.vipcomsistemas.com.br
# 
*/
if ($gerar_qrcode){
   include "phpqrcode/qrlib.php"; 
   include "funcoes_pix.php";
   $px[00]="01"; //Payload Format Indicator, Obrigatório, valor fixo: 01
   // Se o QR Code for para pagamento único (só puder ser utilizado uma vez), descomente a linha a seguir.
   //$px[01]="12"; //Se o valor 12 estiver presente, significa que o BR Code só pode ser utilizado uma vez. 
   $px[26][00]="BR.GOV.BCB.PIX"; //Indica arranjo específico; “00” (GUI) obrigatório e valor fixo: br.gov.bcb.pix
   $px[26][01]=$chave_pix;
   if (!empty($descricao)) {
      $tam_max_descr=99-(4+4+4+14+strlen($chave_pix));
      if (strlen($descricao) > $tam_max_descr) {
         $descricao=substr($descricao,0,$tam_max_descr);
      }
      $px[26][02]=$descricao;
   }
   $px[52]="0000"; //Merchant Category Code “0000” ou MCC ISO18245
   $px[53]="986"; //Moeda, “986” = BRL: real brasileiro - ISO4217
   $px[54]=$valor_pix;
   $px[58]="BR"; //“BR” – Código de país ISO3166-1 alpha 2
   $px[59]=$beneficiario_pix; //Nome do beneficiário/recebedor. Máximo: 25 caracteres.
   $px[60]=$cidade_pix; //Nome cidade onde é efetuada a transação. Máximo 15 caracteres.
   $px[62][05]=$identificador;
   $px[62][50][00]="BR.GOV.BCB.BRCODE"; //Payment system specific template - GUI
   $px[62][50][01]="1.0.0"; //Payment system specific template - versão
   $pix=montaPix($px);
   $pix.="6304"; //Adiciona o campo do CRC no fim da linha do pix.
   $pix.=crcChecksum($pix); //Calcula o checksum CRC16 e acrescenta ao final.
   $linhas=round(strlen($pix)/120)+1;
   ?>
   <div class="card" style="display:none;">
   <h3>Linha do Pix (copia e cola):</h3>
   <div class="row">
      <div class="col">
      <textarea class="text-monospace" id="brcodepix" rows="<?= $linhas; ?>" cols="130" onclick="copiar()"><?= $pix;?></textarea>
      </div>
      <div class="col md-1">
      <p><button type="button" id="clip_btn" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="Copiar código pix" onclick="copiar()"><i class="fas fa-clipboard"></i></button></p>
      </div>
   </div>
   </div>
   
   <!-- <h3>Imagem de QRCode do Pix:</h3> -->
   <p>
   <img src="logo_pix.png"><br>
   <?php
   ob_start();
   QRCode::png($pix, null,'M',5);
   $imageString = base64_encode( ob_get_contents() );
   ob_end_clean();
   // Exibe a imagem diretamente no navegador codificada em base64.
   echo '<img src="data:image/png;base64,' . $imageString . '"></p>';
   
   if(!empty($_POST[email])){
	   
		$res = envia_pix();
		if($res){?>
			<h3>O email foi enviado com sucesso para <b><?=$_POST[email]?></b> </h3>
		<? }  
		else{
			?>
			<h3>Não conseguimos enviar o email para <b><?=$_POST[email]?></b>, verifique com o seu servidor de hospedagem </h3>
		<? }  
		 
	   // ENVIA link para email do destinatario
   }
}
?>
<h3>Gerador de QR Code do PIX</h3>
<div class="card">
<div class="card-body">
<form method="post" action="index.php">
   <div class="row row-cols-lg-auto g-3 align-items-center">
      <label for="chave" class="form-label">Chave Pix:</label>
      <input type="text" id="chave" name="chave" placeholder="Informe a chave pix" value="<?= $chave_pix;?>" size="50" maxlength="100" onclick="this.select();" data-toggle="tooltip" data-placement="right" title="Informe a chave pix de destino" required>
      <div id="chaveHelp" class="form-text">A chave pode ser: Aleatória, E-mail, Telefone, CPF ou CNPJ.</div>
   </div>
   <div class="row row-cols-lg-auto g-3 align-items-center">
      <label for="valor" class="form-label">Valor a pagar:</label>
      <input type="text" id="valor" name="valor" placeholder="Informe o valor a cobrar" size="15" maxlength="13" value="<?= $valor_pix; ?>" onclick="this.select();" onkeypress="mascara(this,reais)" required>
      <div id="valorHelp" class="form-text">Utilize o ponto "." como separador de decimais. Prencher 0 caso não deseje especificar um valor.</div>
   </div>
   <div class="row row-cols-lg-auto g-3 align-items-center">
      <label for="beneficiario" class="form-label">Nome do beneficiário:</label>
      <input type="text" id="beneficiario" name="beneficiario" placeholder="Informe o nome do beneficiario" size="30"  onclick="this.select();" maxlength="25" value="<?= $beneficiario_pix; ?>" required >
   </div>
   <div class="row row-cols-lg-auto g-3 align-items-center">
      <label for="beneficiario" class="form-label">Cidade do beneficiário:</label>
      <input type="text" id="cidade" name="cidade" placeholder="Informe a cidade" onclick="this.select();" maxlength="15" value="<?= $cidade_pix;?>" required>
   </div>
   <div class="row row-cols-lg-auto g-3 align-items-center">
      <label for="descricao" class="form-label">Descrição da cobrança (opcional):</label>
      <input type="text" id="descricao" name="descricao" placeholder="Descricao do pagamento" size="60" maxlength="70" value="<?= $_POST["descricao"];?>" value="<?= $_POST["descricao"];?>" onclick="this.select();">
   </div>
   <div class="row row-cols-lg-auto g-3 align-items-center" style="display:none;	">
      <label for="identificador" class="form-label">Identificador do pagamento:</label>
      <input type="text" id="identificador" name="identificador" placeholder="Identificador do pagamento" value="***" size="25" onclick="this.select();" value="<?= $_POST["identificador"];?>" >
      <div id="identificadorHelp" class="form-text">Utilizar <b>***</b> para identificador gerado automaticamente.O Banco Itaú exige a autorização para uso de identificador que não tenha sido criado pelo aplicativo do próprio banco, <a href="https://github.com/bacen/pix-api/issues/214">saiba mais</a>.</div>
   </div>
   

   
   <p><button type="submit" class="btn btn-primary" style="margin-top: 16px;margin-bottom: 11px;">Gerar QR Code <i class="fas fa-qrcode"></i></button> </p>
   
      <div class="row row-cols-lg-auto g-3 align-items-center"  >
      <label for="identificador" class="form-label">Email (opcional):</label>
      <input type="text" id="identificador" name="email" placeholder="Email de quem irá pagar"  size="25" onclick="this.select();" value=" " >
      <div id="identificadorHelp" class="form-text">  Opcionalmente você também poderá enviar uma cobrança para um email específico </div>
     </div>
	 
	    <div class="row row-cols-lg-auto g-3 align-items-center"  >
      <label for="identificador" class="form-label">Conteúdo do Email </label>
      <input type="text" id="identificador" name="conteudo_email"   value="Olá, para realizar o pagamento, clique no link abaixo e aponte o leitor de Qrcode do seu celular." size="25" onclick="this.select();" value=" " >
      <div id="identificadorHelp" class="form-text">   </div>
     </div>
	 
   
   <p><button type="submit" onsubmit="vercampos();" class="btn btn-primary" style="margin-top: 16px;">Enviar para email <i class="fas fa-email"></i></button> </p>
</form> 
</div></div>
 
</body>
</html>

<?
function envia_pix() {
  
	Util::log("envia_pix" );
  
	global $INI,$ROOTPATH,$link;
	$site =  $INI['system']['sitename'];
	 
	  
	$body =
	"<html><body style='font-size:12px;'><meta http-equiv='Content-Type' content='text/html; charset=utf8' /><meta http-equiv='Content-Language' content='pt-br' />
	<div>".$_POST[conteudo_email]."  </div>
	  
	 <BR>
	 <a target='_blank' href='$link'>PAGAR COM QRCODE</a>
	 <BR>
	 
	 
	 <p>Atenciosamente</p> 
	 <p>Equipe $site</p> 
	 
	 </body></html>" ;
   
	 if(enviar( $_POST[email], "Você recebeu uma cobrança do site $site" , $body )){
			Util::log("email de cobranca por pix enviado com sucesso para ". $_POST[email] ); 
			return true;
	 }
	 else{ 
	    Util::log("erro no envio do email para ".$_POST[email] );
		return false;
	 } 
}

?>