/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface  The Monotype Corporation plc. Data  The Monotype Corporation plc /
 * Type Solutions Inc. 1990-91 All Rights Reserved
 * 
 * Trademark:
 * Century Gothic is a trademark of The Monotype Corporation plc.
 * 
 * Description:
 * A design based on Monotype 20th Century, which was drawn by Sol Hess between
 * 1936 and 1947. Century Gothic maintains the basic design of 20th Century but has
 * an enlarged 'x' height and has been modified to ensure satisfactory output from
 * modern digital systems. The design is influenced by the geometric style sans
 * serif faces which were popular during the 1920's and 30's. Useful for headlines
 * and general display work and for small quantities of text, particularly in
 * advertising.
 * 
 * Manufacturer:
 * Monotype Typography, Inc.
 * 
 * Designer:
 * Monotype Type Drawing Office
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_welcome.html
 * 
 * License information:
 * http://www.monotype.com/html/type/license.html
 */
Cufon.registerFont({"w":199,"face":{"font-family":"Century Gothic","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 5 2 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-28 -350 395 79.2683","underline-thickness":"20.918","underline-position":"-24.2578","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":99},"!":{"d":"66,-265r0,200r-26,0r0,-200r26,0xm31,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22","w":106},"\"":{"d":"99,-184r-18,0r-4,-81r26,0xm31,-184r-19,0r-4,-81r26,0","w":111},"#":{"d":"217,-106r0,19r-44,0r-13,87r-19,0r12,-87r-58,0r-13,87r-20,0r14,-87r-44,0r0,-19r47,0r9,-59r-45,0r0,-19r47,0r13,-82r18,0r-11,82r58,0r12,-82r20,0r-13,82r40,0r0,19r-42,0r-9,59r41,0xm165,-165r-58,0r-9,59r58,0","w":259},"$":{"d":"29,-197v0,-37,27,-58,64,-62r0,-18r23,0r0,19v26,6,39,15,53,36r-19,15v-9,-14,-20,-22,-34,-25r0,87v48,28,72,32,72,82v0,41,-28,65,-72,69r0,55r-23,0r0,-55v-41,-3,-63,-19,-80,-46r18,-14v16,22,37,34,62,36r0,-109v-40,-20,-64,-24,-64,-70xm93,-234v-31,0,-49,33,-31,58v6,9,17,16,31,22r0,-80xm116,-19v36,-2,62,-41,37,-71v-7,-9,-19,-17,-37,-27r0,98"},"%":{"d":"68,-265v49,9,106,12,154,-5r21,0r-189,288r-23,0r171,-262v-22,6,-52,7,-83,7v29,39,-4,94,-51,94v-33,0,-62,-28,-60,-61v1,-35,25,-60,60,-61xm108,-204v0,-20,-19,-39,-39,-39v-20,0,-39,19,-39,39v0,20,18,38,39,38v21,0,39,-18,39,-38xm149,-53v0,-33,28,-61,61,-61v33,0,61,28,61,61v0,33,-28,61,-61,61v-33,0,-61,-28,-61,-61xm249,-53v1,-20,-18,-39,-39,-39v-21,0,-38,18,-38,39v0,20,18,38,38,38v21,0,39,-18,39,-38","w":278},"&":{"d":"175,-202v-2,32,-19,42,-45,65r66,68v19,-16,19,-16,31,-27r18,19v-11,10,-22,19,-31,26r49,51r-36,0r-33,-35v-37,27,-49,42,-96,42v-37,0,-67,-25,-67,-60v0,-45,26,-56,63,-88v-20,-27,-34,-32,-34,-61v0,-64,118,-61,115,0xm117,-224v-21,0,-38,16,-28,35v6,10,15,21,25,33v18,-14,30,-26,35,-46v0,-14,-15,-22,-32,-22xm57,-55v1,29,39,47,70,32v14,-6,30,-17,49,-30r-65,-69v-31,26,-47,34,-54,67","w":272},"'":{"d":"45,-184r-18,0r-4,-81r26,0","w":71},"(":{"d":"111,-270v-46,84,-50,251,-9,345r-27,0v-39,-94,-36,-257,8,-345r28,0","w":132},")":{"d":"57,-270v41,93,37,257,-7,345r-28,0v45,-87,51,-252,8,-345r27,0","w":132},"*":{"d":"65,-265r23,0r-5,52r43,-31r11,20r-48,22r48,21r-11,20r-43,-30r5,52r-23,0r5,-52r-43,30r-12,-20r50,-21r-50,-22r12,-20r43,31","w":152},"+":{"d":"97,-141r0,-77r24,0r0,77r77,0r0,24r-77,0r0,76r-24,0r0,-76r-77,0r0,-24r77,0","w":218},",":{"d":"52,-47r24,11r-36,66r-18,-7","w":99},"-":{"d":"11,-108r97,0r0,22r-97,0r0,-22","w":119},"\u00ad":{"d":"11,-108r97,0r0,22r-97,0r0,-22","w":119},".":{"d":"33,-17v0,-12,10,-22,21,-22v12,0,22,10,22,22v0,12,-9,23,-22,22v-12,0,-21,-10,-21,-22","w":99},"\/":{"d":"147,-265r-107,300r-27,0r107,-300r27,0","w":157},"0":{"d":"98,7v-66,0,-87,-58,-87,-136v0,-79,19,-136,87,-136v68,0,90,59,90,136v0,77,-23,136,-90,136xm99,-240v-51,6,-63,48,-63,111v0,64,11,112,63,112v52,0,65,-55,65,-112v0,-59,-14,-107,-65,-111"},"1":{"d":"67,-259r50,0r0,259r-25,0r0,-233r-41,0"},"2":{"d":"102,-240v-37,0,-58,25,-60,62r-25,0v0,-50,38,-86,86,-87v60,-2,101,64,69,118v-21,36,-74,87,-105,122r119,0r0,25r-175,0r99,-107v29,-34,45,-39,48,-80v2,-29,-26,-54,-56,-53"},"3":{"d":"97,-240v-29,1,-39,16,-49,41r-27,0v8,-38,34,-64,76,-66v69,-4,103,88,41,120v26,9,48,37,48,68v0,71,-91,109,-144,64v-15,-13,-24,-31,-29,-56r25,0v8,32,25,49,60,50v35,1,62,-24,62,-56v0,-41,-29,-55,-76,-56r0,-24v32,-1,60,-12,60,-43v1,-24,-21,-43,-47,-42"},"4":{"d":"153,-265r6,0r0,180r31,0r0,25r-31,0r0,60r-26,0r0,-60r-124,0xm133,-85r0,-108r-76,108r76,0"},"5":{"d":"157,-85v0,-59,-64,-73,-116,-45r24,-129r112,0r0,25r-92,0r-13,71v61,-20,112,20,112,79v0,102,-158,126,-169,21r26,0v5,28,23,44,54,45v35,1,62,-31,62,-67"},"6":{"d":"103,7v-57,0,-96,-57,-72,-113v24,-55,70,-108,101,-159r21,14r-70,106v53,-20,102,21,101,72v-1,47,-34,80,-81,80xm158,-73v0,-29,-25,-54,-54,-54v-30,0,-55,25,-55,54v0,29,26,54,55,54v28,0,54,-26,54,-54"},"7":{"d":"26,-259r164,0r-138,266r-22,-11r120,-230r-124,0r0,-25"},"8":{"d":"175,-197v0,29,-16,43,-37,55v28,15,48,31,49,68v0,48,-37,81,-88,81v-51,0,-87,-35,-87,-79v0,-36,21,-55,50,-70v-22,-11,-38,-29,-38,-56v0,-39,34,-67,77,-67v42,0,74,28,74,68xm149,-198v0,-23,-20,-42,-49,-42v-26,0,-49,18,-49,43v-1,23,26,46,50,45v26,-2,48,-19,48,-46xm161,-74v0,-29,-29,-55,-60,-55v-34,0,-64,27,-63,58v1,33,27,53,62,53v35,1,61,-24,61,-56"},"9":{"d":"98,-265v82,-2,89,94,49,155r-78,117r-21,-14r70,-106v-53,20,-101,-21,-100,-72v0,-49,34,-79,80,-80xm43,-185v0,28,26,54,54,54v29,0,55,-25,55,-54v0,-29,-26,-55,-55,-55v-29,0,-54,26,-54,55"},":":{"d":"33,-174v0,-12,9,-22,21,-22v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21xm33,-17v0,-12,10,-22,21,-22v12,0,22,10,22,22v0,12,-9,23,-22,22v-12,0,-21,-10,-21,-22","w":99},";":{"d":"33,-174v0,-12,9,-22,21,-22v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21xm52,-47r24,11r-36,66r-18,-7","w":99},"\u037e":{"d":"33,-174v0,-12,9,-22,21,-22v12,0,23,9,22,22v0,12,-10,21,-22,21v-12,0,-21,-9,-21,-21xm52,-47r24,11r-36,66r-18,-7","w":99},"<":{"d":"200,-61r0,26r-182,-83r0,-23r182,-82r0,25r-148,69","w":218},"=":{"d":"198,-180r0,24r-178,0r0,-24r178,0xm198,-103r0,24r-178,0r0,-24r178,0","w":218},">":{"d":"18,-61r148,-68r-148,-69r0,-25r182,82r0,23r-182,83r0,-26","w":218},"?":{"d":"107,-240v-31,0,-52,19,-52,52r-25,0v-1,-47,31,-77,77,-77v62,0,97,63,52,102v-19,16,-88,25,-87,56v0,16,18,26,36,26v26,0,35,-13,38,-37r26,0v-2,38,-25,62,-64,62v-34,0,-62,-20,-62,-51v0,-65,106,-45,109,-97v1,-22,-23,-36,-48,-36xm85,-17v0,-12,10,-22,22,-22v11,0,21,10,21,22v0,12,-9,22,-21,22v-12,0,-23,-9,-22,-22","w":212},"@":{"d":"38,-133v-6,114,153,162,216,80r18,0v-29,37,-54,58,-108,58v-82,0,-140,-55,-140,-137v0,-81,56,-137,138,-139v65,-2,126,52,126,113v0,59,-39,99,-90,104v-13,1,-22,-4,-21,-19v-31,38,-101,8,-97,-46v3,-42,30,-85,75,-83v24,1,35,9,46,26r5,-24r19,0r-22,122v0,5,3,10,9,9v34,-6,62,-42,62,-85v0,-58,-53,-102,-113,-101v-74,1,-119,50,-123,122xm157,-183v-56,-3,-75,107,-10,108v50,1,68,-107,10,-108","w":312},"A":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"B":{"d":"187,-74v0,44,-37,75,-84,74r-71,0r0,-259v69,-3,134,0,134,64v0,26,-14,44,-33,54v32,11,54,28,54,67xm139,-195v1,-39,-40,-40,-82,-38r0,83v47,2,80,-5,82,-45xm160,-74v0,-47,-45,-52,-103,-50r0,99v55,2,103,-1,103,-49","w":206},"C":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138","w":292},"D":{"d":"249,-126v0,81,-45,128,-135,126r-83,0r0,-259r54,0v111,-3,164,38,164,133xm223,-126v0,-89,-61,-113,-167,-107r0,209v104,5,167,-13,167,-102","w":267},"E":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259","w":193},"F":{"d":"31,-259r130,0r0,26r-104,0r0,81r104,0r0,25r-104,0r0,127r-26,0r0,-259","w":174},"G":{"d":"21,-129v-1,-102,103,-162,203,-124v19,8,39,21,57,38r-20,19v-24,-24,-58,-43,-98,-43v-64,0,-111,45,-115,109v-8,122,200,156,219,31r-82,0r0,-25r111,0v1,80,-52,129,-130,131v-80,2,-144,-58,-145,-136","w":313},"H":{"d":"31,-259r26,0r0,109r132,0r0,-109r26,0r0,259r-26,0r0,-125r-132,0r0,125r-26,0r0,-259","w":245},"I":{"d":"28,-259r26,0r0,259r-26,0r0,-259","w":81},"J":{"d":"29,-41v36,34,87,33,87,-44r0,-174r26,0r0,175v15,96,-75,110,-127,63","w":173},"K":{"d":"31,-259r27,0r0,97r103,-97r35,0r-124,116r134,143r-35,0r-113,-121r0,121r-27,0r0,-259","w":212},"L":{"d":"31,-259r26,0r0,234r100,0r0,25r-126,0r0,-259","w":166},"M":{"d":"20,0r36,-259r5,0r105,213r104,-213r4,0r37,259r-25,0r-26,-185r-91,185r-7,0r-92,-186r-25,186r-25,0","w":330},"N":{"d":"32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0","w":266},"O":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110","w":312},"P":{"d":"193,-190v-4,67,-55,73,-136,70r0,120r-26,0r0,-259r52,0v74,-3,102,12,110,69xm166,-190v0,-49,-56,-44,-109,-43r0,87v52,2,109,7,109,-44","w":213},"Q":{"d":"293,-129v-1,46,-18,76,-45,101r39,48r-32,0r-26,-33v-90,57,-212,-14,-208,-115v3,-80,55,-135,135,-137v75,-2,138,62,137,136xm47,-128v-3,81,92,138,165,94r-57,-73r31,0r46,59v70,-63,23,-196,-75,-192v-64,3,-108,47,-110,112","w":313},"R":{"d":"195,-190v0,50,-35,70,-90,70r93,120r-32,0r-93,-120r-14,0r0,120r-26,0r0,-259v84,-2,162,-5,162,69xm168,-190v0,-49,-56,-44,-109,-43r0,88v53,1,109,5,109,-45","w":218},"S":{"d":"144,-102v44,64,-39,141,-104,96v-13,-8,-24,-22,-35,-42r22,-13v15,28,33,42,53,42v27,0,48,-17,48,-44v0,-62,-107,-74,-107,-141v0,-49,54,-76,97,-52v11,6,22,17,34,33r-21,16v-16,-20,-22,-29,-48,-31v-36,-3,-46,46,-19,66v13,9,74,54,80,70","w":179},"T":{"d":"6,-233r0,-26r142,0r0,26r-58,0r0,233r-26,0r0,-233r-58,0","w":153},"U":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266","w":235},"V":{"d":"12,-259r28,0r86,200r87,-200r28,0r-113,259r-5,0","w":252},"W":{"d":"17,-259r26,0r53,187r74,-187r5,0r74,187r53,-187r27,0r-74,259r-5,0r-77,-196r-78,196r-5,0","w":345},"X":{"d":"18,-259r30,0r62,101r62,-101r30,0r-77,126r82,133r-30,0r-67,-108r-68,108r-30,0r83,-133","w":219},"Y":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124","w":213},"Z":{"d":"21,-234r0,-25r137,0r-108,234r102,0r0,25r-142,0r109,-234r-98,0","w":172},"[":{"d":"51,-265r59,0r0,25r-34,0r0,286r34,0r0,24r-59,0r0,-335","w":126},"\\":{"d":"39,-265r167,300r-27,0r-167,-300r27,0","w":217},"]":{"d":"75,70r-59,0r0,-25r35,0r0,-286r-35,0r0,-24r59,0r0,335","w":126},"^":{"d":"111,-259r20,0r90,195r-23,0r-78,-168r-76,168r-23,0","w":241},"_":{"d":"-2,27r184,0r0,18r-184,0r0,-18","w":180},"`":{"d":"57,-281r39,54r-25,0r-51,-54r37,0","w":136},"a":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"b":{"d":"129,5v-36,-1,-59,-18,-76,-40r0,35r-24,0r0,-265r24,0r0,107v17,-23,41,-37,77,-38v54,-2,98,48,98,101v0,53,-45,101,-99,100xm52,-97v0,42,34,79,75,78v45,-1,76,-32,76,-77v0,-44,-31,-78,-75,-78v-44,0,-76,30,-76,77","w":245},"c":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99","w":232},"d":{"d":"118,-196v36,1,59,17,76,40r0,-109r24,0r0,265r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm196,-95v0,-42,-35,-78,-76,-77v-45,1,-76,32,-76,77v0,44,32,77,76,77v44,0,76,-31,76,-77","w":246},"e":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0","w":233},"f":{"d":"39,-191v-1,-42,-2,-81,39,-79v8,0,17,2,28,5r0,24v-23,-10,-47,-11,-42,24r0,26r40,0r0,21r-40,0r0,170r-25,0r0,-170r-25,0r0,-21r25,0","w":113},"g":{"d":"18,-97v0,-94,127,-132,174,-61r0,-33r25,0r0,152v24,131,-159,148,-197,54r27,0v31,61,167,48,145,-51v-46,66,-174,33,-174,-61xm193,-97v0,-45,-29,-75,-73,-75v-45,0,-76,32,-78,76v-2,42,33,73,76,73v44,0,75,-30,75,-74","w":242},"h":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-265r25,0r0,108v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173","w":219},"i":{"d":"16,-250v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-11,0,-20,-10,-20,-21xm24,-191r25,0r0,191r-25,0r0,-191","w":72},"j":{"d":"16,-250v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21xm-11,47v21,10,35,5,35,-25r0,-213r25,0r0,220v4,42,-26,55,-60,40r0,-22","w":73},"k":{"d":"27,-265r25,0r0,151r88,-77r37,0r-105,91r111,100r-35,0r-96,-86r0,86r-25,0r0,-265","w":180},"l":{"d":"24,-265r24,0r0,265r-24,0r0,-265","w":72},"m":{"d":"113,-172v-73,0,-61,94,-61,172r-25,0r0,-191r25,0r0,33v15,-22,34,-38,65,-38v35,1,51,18,61,46v13,-26,36,-45,70,-46v85,-1,62,111,65,196r-25,0v-7,-66,25,-173,-45,-172v-74,1,-60,94,-61,172r-24,0v-6,-66,23,-172,-45,-172","w":337},"n":{"d":"119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173","w":219},"o":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77","w":235},"p":{"d":"129,5v-35,-2,-59,-16,-77,-38r0,103r-24,0r0,-261r24,0r0,35v17,-23,40,-39,76,-40v54,-1,99,47,99,100v0,53,-45,102,-98,101xm202,-95v0,-45,-31,-76,-76,-77v-41,-1,-76,35,-76,77v0,46,33,77,77,77v43,0,75,-34,75,-77","w":245},"q":{"d":"117,-196v37,1,60,17,77,40r0,-35r24,0r0,261r-24,0r0,-103v-18,23,-42,36,-77,38v-53,1,-98,-47,-98,-101v0,-53,45,-101,98,-100xm195,-95v1,-42,-35,-78,-76,-77v-45,1,-76,33,-76,77v0,42,32,77,76,77v44,0,75,-31,76,-77","w":245},"r":{"d":"43,0r-25,0r0,-191r25,0r0,28v15,-23,40,-43,72,-27r-13,21v-75,-15,-56,95,-59,169","w":108},"s":{"d":"18,-146v4,-55,72,-66,106,-24r-16,16v-21,-26,-62,-26,-68,7v7,45,84,41,84,96v0,59,-86,74,-115,29r16,-18v13,14,26,22,40,22v18,0,35,-14,35,-32v-4,-47,-86,-40,-82,-96","w":139},"t":{"d":"49,-262r25,0r0,71r39,0r0,21r-39,0r0,170r-25,0r0,-170r-34,0r0,-21r34,0r0,-71","w":121},"u":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196","w":218},"v":{"d":"9,-191r27,0r63,139r64,-139r26,0r-87,191r-5,0"},"w":{"d":"2,-191r25,0r58,139r62,-139r4,0r61,139r60,-139r26,0r-83,191r-5,0r-61,-137r-61,137r-5,0","w":299},"x":{"d":"6,-191r29,0r51,71r50,-71r30,0r-65,91r73,100r-30,0r-58,-80r-58,80r-29,0r72,-100","w":172},"y":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84","w":193},"z":{"d":"12,-191r140,0r-108,169r105,0r0,22r-147,0r108,-170r-98,0r0,-21","w":152},"{":{"d":"50,-7v0,-44,-2,-64,-37,-68r0,-29v40,-4,37,-33,37,-81v0,-56,12,-76,65,-74r0,28v-29,0,-37,5,-36,36v0,63,1,86,-36,105v29,14,36,33,36,80v0,48,-7,62,36,62r0,27v-59,2,-65,-24,-65,-86","w":126},"|":{"d":"108,-265r25,0r0,335r-25,0r0,-335","w":241},"}":{"d":"77,-172v-1,45,1,64,36,68r0,29v-39,0,-37,40,-36,80v1,55,-12,77,-66,74r0,-27v29,0,37,-5,36,-36v0,-63,1,-87,37,-106v-31,-16,-36,-31,-37,-79v0,-52,6,-60,-36,-62r0,-28v59,-2,67,25,66,87","w":126},"~":{"d":"154,-128v21,-1,21,-7,44,-19r0,28v-20,10,-25,15,-44,17v-22,3,-66,-28,-88,-28v-21,0,-26,7,-46,19r0,-29v20,-10,25,-14,44,-16v22,-2,65,29,90,28","w":218},"\u00c4":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm77,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm149,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":266},"\u00c5":{"d":"96,-312v0,-20,17,-38,37,-38v20,0,39,17,38,38v0,20,-18,37,-38,37v-20,0,-37,-17,-37,-37xm152,-313v0,-9,-10,-19,-19,-19v-9,0,-20,9,-19,19v-1,10,9,20,19,20v10,0,19,-10,19,-20xm137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"\u00c7":{"d":"20,-131v0,-99,109,-165,204,-120v19,10,36,23,48,40r-20,16v-20,-26,-51,-45,-93,-45v-65,0,-109,45,-112,112v-4,105,145,149,205,68r20,15v-24,30,-61,52,-113,52v-80,2,-139,-58,-139,-138xm161,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":292},"\u00c9":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm119,-333r38,0r-52,54r-24,0","w":193},"\u00d1":{"d":"69,-302v33,-42,79,15,116,-12r13,17v-35,39,-87,-20,-118,13xm32,0r0,-259r5,0r172,198r0,-198r26,0r0,259r-6,0r-171,-195r0,195r-26,0","w":266},"\u00d6":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm100,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm172,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":312},"\u00dc":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm62,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm134,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":235},"\u00e1":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm134,-281r38,0r-52,54r-24,0","w":245},"\u00e0":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm112,-281r39,54r-25,0r-51,-54r37,0","w":245},"\u00e2":{"d":"111,-271r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"\u00e4":{"d":"118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77xm67,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm139,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":245},"\u00e3":{"d":"59,-250v33,-42,79,15,116,-12r12,17v-34,39,-86,-20,-117,13xm118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"\u00e5":{"d":"85,-260v0,-20,18,-37,38,-37v20,0,37,17,37,37v0,20,-17,38,-37,38v-20,0,-39,-17,-38,-38xm142,-260v0,-9,-9,-20,-19,-19v-10,-1,-20,9,-20,19v0,10,10,19,20,19v9,0,19,-10,19,-19xm118,-196v36,1,59,18,76,40r0,-35r24,0r0,191r-24,0r0,-33v-18,23,-42,36,-77,38v-53,1,-98,-48,-98,-101v0,-53,45,-101,99,-100xm195,-95v0,-42,-34,-78,-75,-77v-45,1,-76,32,-76,77v0,43,32,77,75,77v44,0,76,-30,76,-77","w":245},"\u00e7":{"d":"18,-94v0,-102,146,-136,195,-58r-19,13v-40,-61,-151,-34,-151,43v0,78,109,104,151,45r19,13v-17,25,-47,43,-89,43v-57,0,-106,-43,-106,-99xm131,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":232},"\u00e9":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm129,-281r38,0r-52,54r-24,0","w":233},"\u00e8":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm106,-281r39,54r-25,0r-51,-54r37,0","w":233},"\u00ea":{"d":"105,-271r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0","w":233},"\u00eb":{"d":"116,-18v39,-2,56,-16,72,-45r21,10v-17,34,-42,57,-91,58v-58,1,-100,-47,-100,-100v0,-54,43,-101,98,-101v56,0,100,43,100,102r-172,0v-1,42,31,78,72,76xm188,-115v-6,-52,-80,-76,-120,-40v-10,9,-17,22,-22,40r142,0xm61,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm133,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":233},"\u00ed":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm48,-281r38,0r-52,54r-24,0","w":72},"\u00ec":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm25,-281r39,54r-25,0r-51,-54r37,0","w":72},"\u00ee":{"d":"24,-271r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm24,-191r25,0r0,191r-25,0r0,-191","w":72},"\u00ef":{"d":"24,-191r25,0r0,191r-25,0r0,-191xm-20,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm52,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":72},"\u00f1":{"d":"45,-250v34,-42,79,15,117,-12r12,17v-21,20,-57,17,-80,2v-17,-3,-25,1,-37,11xm119,-173v-76,1,-68,89,-67,173r-25,0r0,-191r25,0r0,34v17,-22,38,-38,72,-39v87,-1,69,108,70,196r-24,0v-5,-70,22,-174,-51,-173","w":219},"\u00f3":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm129,-281r38,0r-52,54r-24,0","w":235},"\u00f2":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm107,-281r39,54r-25,0r-51,-54r37,0","w":235},"\u00f4":{"d":"106,-271r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77","w":235},"\u00f6":{"d":"18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77xm62,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm134,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":235},"\u00f5":{"d":"53,-250v34,-42,79,15,117,-12r12,17v-34,39,-86,-20,-117,13xm18,-95v0,-54,45,-101,100,-101v54,0,99,45,99,101v0,54,-44,100,-99,100v-55,0,-100,-46,-100,-100xm192,-95v2,-40,-35,-77,-74,-77v-39,0,-77,36,-75,77v1,44,31,77,75,77v44,0,72,-33,74,-77","w":235},"\u00fa":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm121,-281r38,0r-52,54r-24,0","w":218},"\u00f9":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm98,-281r39,54r-25,0r-51,-54r37,0","w":218},"\u00fb":{"d":"98,-271r24,0r51,45r-31,0r-31,-27r-33,27r-32,0xm108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196","w":218},"\u00fc":{"d":"108,5v-98,0,-84,-101,-84,-196r25,0v3,75,-18,178,59,172v46,-3,58,-23,58,-83r0,-89r26,0v0,0,14,196,-84,196xm53,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm125,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":218},"\u00b0":{"d":"72,-265v33,0,61,28,61,60v0,33,-28,61,-61,61v-33,0,-61,-28,-61,-61v0,-33,28,-60,61,-60xm72,-163v21,0,40,-20,40,-41v0,-22,-18,-42,-39,-42v-22,0,-41,18,-41,41v0,22,18,42,40,42","w":143},"\u00a2":{"d":"55,-14v-79,-56,-19,-220,91,-176r23,-46r21,11r-23,45v8,5,15,11,20,17r-15,18v-5,-5,-10,-9,-16,-13r-70,134v32,13,52,4,80,-16r16,18v-24,22,-67,36,-107,20r-26,52r-21,-11xm134,-169v-74,-28,-121,80,-68,132"},"\u00a3":{"d":"10,-27v0,-30,35,-52,64,-33v4,-25,1,-45,-6,-66r-51,0r0,-22r45,0v-35,-70,10,-137,81,-110v18,12,29,30,31,60r-24,0v0,-25,-12,-44,-36,-44v-52,-1,-41,59,-26,94r57,0r0,22r-51,0v7,24,10,56,3,80v10,7,30,25,49,26v11,0,17,-13,18,-40r25,0v-1,33,-10,67,-40,67v-24,0,-46,-16,-61,-29v-13,39,-77,39,-78,-5xm34,-30v4,21,28,14,34,-6v-14,-11,-32,-12,-34,6"},"\u00a7":{"d":"69,-161v-53,-25,-34,-114,34,-109v39,3,62,23,66,60r-25,0v1,-44,-81,-47,-81,-4v0,63,113,55,113,123v0,27,-25,47,-51,52v20,13,38,31,39,59v2,75,-129,68,-136,4r26,0v7,38,84,38,84,-4v0,-61,-115,-61,-115,-128v0,-30,21,-46,46,-53xm105,-54v31,-1,59,-31,37,-58v-5,-5,-25,-21,-53,-35v-32,1,-53,36,-31,61v8,9,24,20,47,32","w":221},"\u00b6":{"d":"17,-194v0,-43,24,-72,72,-72r91,0r0,13r-15,0r0,294r-21,0r0,-294r-38,0r0,294r-21,0r0,-165v-46,0,-68,-26,-68,-70","w":203},"\u00df":{"d":"103,-246v-38,4,-50,21,-50,73r0,173r-25,0r0,-175v-2,-65,20,-91,74,-95v40,-3,71,26,70,64v-1,36,-24,54,-58,59v43,5,64,33,67,75v3,57,-59,96,-110,68r0,-23v39,23,85,0,85,-45v0,-40,-28,-61,-69,-61r0,-28v33,3,60,-16,60,-44v0,-23,-20,-43,-44,-41"},"\u00ae":{"d":"135,-271v80,0,138,59,138,137v0,81,-58,139,-138,139v-79,0,-139,-58,-139,-138v0,-80,58,-138,139,-138xm135,-14v68,0,118,-50,118,-119v0,-68,-49,-120,-118,-120v-69,0,-119,52,-119,120v0,68,50,119,119,119xm178,-55v-8,-30,7,-73,-36,-66r-40,0r0,66r-25,0r0,-159v56,1,125,-11,123,45v-1,18,-6,25,-20,35v29,8,9,56,26,79r-28,0xm175,-168v0,-32,-43,-21,-73,-23r0,47v31,-1,73,8,73,-24","w":268},"\u00a9":{"d":"135,-271v80,0,138,58,138,138v0,80,-58,138,-138,138v-80,0,-139,-58,-139,-138v0,-80,58,-138,139,-138xm135,-14v68,0,118,-49,118,-119v0,-70,-50,-119,-119,-119v-68,0,-118,51,-118,119v0,69,50,119,119,119xm62,-132v0,-68,69,-108,120,-70v13,9,19,24,20,40r-24,0v-4,-20,-18,-32,-41,-32v-33,1,-49,25,-49,62v0,68,88,82,90,17r24,0v-4,36,-29,63,-67,63v-46,0,-73,-32,-73,-80","w":268},"\u2122":{"d":"346,-266r0,152r-27,0r0,-125r-56,125r-18,0r-54,-125r0,125r-26,0r0,-152r42,0r47,105r50,-105r42,0xm135,-266r0,24r-53,0r0,128r-27,0r0,-128r-53,0r0,-24r133,0","w":360},"\u00b4":{"d":"79,-281r38,0r-52,54r-24,0","w":135},"\u00a8":{"d":"10,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm82,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":132},"\u00c6":{"d":"0,0r167,-259r160,0r0,27r-122,0r0,79r122,0r0,26r-122,0r0,102r122,0r0,25r-148,0r0,-85r-94,0r-55,85r-30,0xm102,-109r77,0r0,-120","w":357},"\u00d8":{"d":"61,-31v-85,-79,-26,-234,95,-234v30,0,57,9,82,26r26,-31r18,16r-26,31v22,22,34,53,36,94v4,104,-123,175,-212,113r-29,34r-19,-15xm221,-219v-72,-52,-174,0,-174,91v0,30,10,56,31,77xm97,-36v74,45,172,-7,169,-93v0,-29,-10,-54,-28,-74","w":312},"\u00b1":{"d":"87,-160r0,-77r24,0r0,77r77,0r0,24r-77,0r0,76r-24,0r0,-76r-77,0r0,-24r77,0xm188,-28r0,24r-178,0r0,-24r178,0","w":197},"\u00a5":{"d":"159,-259r29,0r-73,130r63,0r0,20r-66,0r0,27r66,0r0,21r-66,0r0,61r-25,0r0,-61r-65,0r0,-21r65,0r0,-27r-65,0r0,-20r62,0r-73,-130r29,0r59,106"},"\u00b5":{"d":"157,-21v-19,33,-86,32,-106,1r0,90r-25,0r0,-261r25,0v3,71,-20,170,53,169v72,-1,50,-99,53,-169r25,0r0,191r-25,0r0,-21","w":207},"\u00aa":{"d":"10,-202v-6,-51,60,-85,87,-43r0,-17r20,0r0,120r-20,0r0,-17v-27,41,-94,8,-87,-43xm98,-202v0,-23,-14,-44,-34,-44v-44,0,-44,88,0,88v20,0,34,-21,34,-44","w":132},"\u00ba":{"d":"10,-202v0,-34,25,-63,56,-63v32,0,57,30,57,63v0,33,-24,62,-57,62v-33,0,-56,-28,-56,-62xm102,-202v0,-24,-15,-43,-36,-44v-45,0,-47,88,0,88v21,-1,36,-20,36,-44","w":132},"\u00e6":{"d":"21,-96v0,-96,129,-134,175,-60r0,-35r23,0r0,34v28,-47,109,-51,148,-10v18,20,28,44,28,74r-172,0v3,43,30,75,75,75v37,0,56,-17,70,-45r21,11v-20,62,-136,78,-170,18r0,34r-23,0r0,-35v-19,25,-40,39,-76,40v-53,1,-99,-47,-99,-101xm368,-114v-5,-60,-95,-77,-129,-31v-7,8,-12,19,-15,31r144,0xm197,-95v-1,-46,-30,-77,-76,-77v-43,0,-74,32,-75,76v-1,42,35,78,76,78v42,0,75,-35,75,-77","w":416},"\u00f8":{"d":"49,-22v-65,-57,-19,-174,68,-174v24,0,44,7,62,21r21,-24r16,13r-22,26v55,62,5,165,-76,165v-19,0,-37,-4,-53,-14r-20,24r-16,-13xm163,-156v-57,-46,-145,16,-114,91v4,10,9,18,16,25xm81,-28v70,41,144,-47,96,-113","w":235},"\u00bf":{"d":"85,-173v0,-12,9,-22,21,-22v12,0,22,10,22,22v0,11,-10,21,-22,21v-12,0,-21,-9,-21,-21xm106,50v31,0,52,-19,52,-52r25,0v1,47,-31,77,-77,77v-41,0,-72,-24,-74,-61v-3,-63,99,-51,109,-97v0,-16,-17,-28,-36,-27v-26,0,-36,13,-38,38r-26,0v2,-38,25,-62,64,-62v35,0,62,20,62,51v3,64,-106,45,-109,97v-1,22,23,36,48,36","w":212},"\u00a1":{"d":"31,-173v0,-12,10,-22,22,-22v12,0,22,10,22,22v0,11,-10,21,-22,21v-12,0,-22,-10,-22,-21xm41,75r0,-201r25,0r0,201r-25,0","w":106},"\u00ac":{"d":"198,-180r0,101r-24,0r0,-77r-154,0r0,-24r178,0","w":218},"\u00ab":{"d":"69,-191r-39,96r39,95r-26,0r-39,-95r39,-96r26,0xm149,-191r-39,96r39,95r-26,0r-39,-95r39,-96r26,0","w":152},"\u00bb":{"d":"84,0r39,-96r-39,-95r26,0r39,95r-39,96r-26,0xm4,0r39,-96r-39,-95r26,0r39,95r-39,96r-26,0","w":152},"\u2026":{"d":"158,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22xm38,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22xm278,-17v0,-27,44,-28,44,0v0,12,-10,22,-22,22v-12,0,-22,-10,-22,-22","w":360},"\u00a0":{"w":100},"\u00c0":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm122,-333r39,54r-25,0r-51,-54r37,0","w":266},"\u00c3":{"d":"69,-302v33,-42,79,15,116,-12r13,17v-35,39,-87,-20,-118,13xm137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"\u00d5":{"d":"92,-302v33,-42,79,15,116,-12r13,17v-34,39,-87,-19,-117,13xm20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110","w":312},"\u2013":{"d":"-2,-112r184,0r0,23r-184,0r0,-23","w":180},"\u2014":{"d":"-2,-112r364,0r0,23r-364,0r0,-23","w":360},"\u201c":{"d":"51,-265r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96xm129,-265r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96","w":180},"\u201d":{"d":"127,-169r-14,-7v7,-17,11,-21,13,-41r-16,0r0,-48r32,0v0,41,1,70,-15,96xm49,-169r-14,-7v7,-17,11,-21,12,-41r-15,0r0,-48r32,0v0,41,1,70,-15,96","w":174},"\u2018":{"d":"65,-265r14,8v-7,17,-11,21,-13,40r16,0r0,48r-32,0v0,-41,-1,-70,15,-96","w":126},"\u2019":{"d":"61,-169r-14,-7v7,-17,11,-21,13,-41r-16,0r0,-48r32,0v0,41,1,70,-15,96","w":126},"\u00f7":{"d":"81,-212r35,0r0,35r-35,0r0,-35xm10,-141r178,0r0,24r-178,0r0,-24xm81,-82r35,0r0,36r-35,0r0,-36","w":197},"\u00ff":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm42,-246v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm114,-246v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":193},"\u00a4":{"d":"156,-38v-27,25,-86,27,-112,0r-21,20r-16,-16r21,-20v-25,-28,-25,-81,0,-109r-21,-20r16,-16r21,21v27,-24,84,-27,111,-1r21,-20r15,16r-20,20v27,25,26,83,1,109r20,20r-15,16xm100,-174v-35,0,-66,31,-66,66v0,35,31,66,66,66v35,0,66,-31,66,-66v0,-35,-31,-66,-66,-66"},"\u00c2":{"d":"121,-323r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0","w":266},"\u00ca":{"d":"95,-323r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259","w":193},"\u00c1":{"d":"137,-259r121,259r-28,0r-41,-85r-111,0r-41,85r-28,0r122,-259r6,0xm134,-204r-45,94r89,0xm145,-333r38,0r-52,54r-24,0","w":266},"\u00cb":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm51,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm123,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":193},"\u00c8":{"d":"32,-259r148,0r0,26r-123,0r0,81r122,0r0,25r-122,0r0,102r122,0r0,25r-147,0r0,-259xm96,-333r39,54r-25,0r-51,-54r37,0","w":193},"\u00cd":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm52,-333r38,0r-52,54r-24,0","w":81},"\u00ce":{"d":"29,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0xm28,-259r26,0r0,259r-26,0r0,-259","w":81},"\u00cf":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm-16,-298v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,20,-20,20v-11,0,-21,-9,-21,-20xm56,-298v0,-11,9,-21,20,-21v12,0,21,9,21,21v0,11,-10,20,-21,20v-11,0,-20,-9,-20,-20","w":81},"\u00cc":{"d":"28,-259r26,0r0,259r-26,0r0,-259xm30,-333r39,54r-25,0r-51,-54r37,0","w":81},"\u00d3":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm168,-333r38,0r-52,54r-24,0","w":312},"\u00d4":{"d":"145,-323r24,0r51,45r-31,0r-31,-27r-33,27r-32,0xm20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110","w":312},"\u00d2":{"d":"20,-128v2,-80,56,-135,135,-137v76,-2,137,61,137,136v0,74,-61,136,-135,136v-74,0,-138,-62,-137,-135xm266,-129v0,-65,-47,-111,-110,-111v-63,0,-108,47,-109,112v-1,60,49,111,109,109v65,-1,110,-46,110,-110xm145,-333r39,54r-25,0r-51,-54r37,0","w":312},"\u00da":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm129,-333r38,0r-52,54r-24,0","w":235},"\u00db":{"d":"106,-323r25,0r51,45r-32,0r-31,-27r-32,27r-33,0xm121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266","w":235},"\u00d9":{"d":"121,7v-63,0,-89,-33,-89,-109r0,-157r26,0r0,157v-5,59,16,84,61,84v93,0,49,-150,59,-241r26,0v-5,112,31,266,-83,266xm107,-333r39,54r-25,0r-51,-54r37,0","w":235},"\u00b8":{"d":"73,41v-2,-9,-13,-8,-23,-5r5,-36r15,0r-3,21v14,-4,26,6,27,18v-1,28,-43,34,-70,23r4,-13v15,5,44,9,45,-8","w":116},"\u00a6":{"d":"108,-121r0,-144r25,0r0,135xm108,70r0,-168r25,-10r0,178r-25,0","w":241},"\u00d0":{"d":"266,-126v0,81,-46,126,-136,126r-93,0r0,-117r-31,0r0,-24r31,0r0,-118r65,0v110,-3,164,38,164,133xm240,-126v0,-93,-69,-114,-178,-107r0,92r68,0r0,24r-68,0r0,93v106,5,178,-8,178,-102","w":284},"\u00f0":{"d":"18,-96v0,-69,73,-125,141,-89v-11,-15,-24,-28,-38,-41r-38,16r-9,-19r31,-13v-11,-9,-21,-17,-29,-23r34,0v6,4,12,9,18,14r29,-12r9,18r-20,9v40,38,72,77,72,136v0,62,-41,103,-101,105v-54,2,-99,-47,-99,-101xm192,-96v0,-46,-28,-77,-72,-77v-41,0,-77,32,-77,76v0,42,34,79,75,78v43,-2,75,-31,74,-77","w":235},"\u00dd":{"d":"11,-259r30,0r66,107r65,-107r30,0r-82,135r0,124r-25,0r0,-124xm118,-333r38,0r-52,54r-24,0","w":213},"\u00fd":{"d":"7,-191r26,0r66,147r63,-147r27,0r-114,261r-26,0r36,-84xm108,-281r38,0r-52,54r-24,0","w":193},"\u00de":{"d":"193,-129v0,66,-55,72,-136,69r0,60r-26,0r0,-259r26,0r0,61v78,-3,136,2,136,69xm166,-129v0,-50,-56,-45,-109,-44r0,88v53,1,109,6,109,-44","w":213},"\u00fe":{"d":"129,5v-35,-2,-59,-16,-77,-38r0,103r-24,0r0,-335r24,0r0,109v17,-23,40,-39,76,-40v54,-1,99,47,99,100v0,53,-45,102,-98,101xm202,-95v0,-45,-31,-76,-76,-77v-41,-1,-76,35,-76,77v0,46,33,77,77,77v43,0,75,-34,75,-77","w":245},"\u00d7":{"d":"125,-129r59,58r-17,16r-58,-58r-58,58r-16,-16r58,-58r-58,-59r16,-16r58,59r58,-59r17,16","w":218},"\u00b9":{"d":"39,-262r33,0r0,133r-19,0r0,-116r-26,0","w":119},"\u00b2":{"d":"92,-224v-5,-35,-66,-30,-65,7r-18,0v0,-28,24,-48,53,-48v34,0,61,31,43,61v-10,17,-41,42,-58,58r66,0r0,17r-112,0r63,-57v17,-17,24,-19,28,-38","w":119},"\u00b3":{"d":"60,-248v-15,1,-22,8,-28,21r-19,0v3,-48,90,-50,93,-2v0,10,-5,18,-16,25v44,17,21,78,-29,78v-32,0,-48,-15,-53,-42r19,0v3,34,68,32,68,-1v0,-21,-19,-23,-44,-25r0,-17v38,7,46,-37,9,-37","w":123},"\u00bd":{"d":"49,7r162,-272r20,0r-163,272r-19,0xm31,-262r33,0r0,133r-19,0r0,-116r-26,0xm256,-94v-5,-35,-66,-30,-65,7r-18,0v0,-28,24,-48,53,-48v34,0,61,31,43,61v-10,17,-41,42,-58,58r66,0r0,17r-112,0r63,-57v17,-17,24,-19,28,-38","w":299},"\u00bc":{"d":"273,-138r0,93r19,0r0,17r-19,0r0,30r-19,0r0,-30r-76,0xm254,-45r0,-44r-38,44r38,0xm68,7r162,-272r20,0r-162,272r-20,0xm33,-262r33,0r0,133r-19,0r0,-116r-26,0","w":299},"\u00be":{"d":"272,-138r0,93r18,0r0,17r-18,0r0,30r-20,0r0,-30r-76,0xm252,-45r0,-44r-37,44r37,0xm76,7r162,-272r20,0r-163,272r-19,0xm64,-248v-15,1,-22,8,-28,21r-19,0v3,-48,90,-50,93,-2v0,10,-5,18,-16,25v44,17,21,78,-29,78v-32,0,-48,-15,-53,-42r19,0v3,34,68,32,68,-1v0,-21,-19,-23,-44,-25r0,-17v38,7,46,-37,9,-37","w":299},"\u00af":{"d":"-2,-304r184,0r0,19r-184,0r0,-19","w":180},"\u00b7":{"d":"85,-133v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":119},"\u2032":{"d":"41,-184r-18,0r7,-81r26,0","w":71},"\u2033":{"d":"95,-184r-18,0r7,-81r26,0xm27,-184r-19,0r8,-81r26,0","w":111}}});
