<?php

/**
* (c) 2018 Kaer
*/
class Request
{
	// tipos de valores
	const INT = 'INT';
	const STRING = 'STRING';

	
	private static $hotWords = array("CAST(", "<IFRAME", "<SCRIPT", "EVAL(",
		// sql injection
		"INSERT INTO", "UPDATE ", "DELETE FROM", "SELECT *", "SELECT ", "SELECT(",
		"USER()", "SLEEP(", "OUTFILE ",
		"SYSTEM("
	);

	private function __construct(){}


	public static function requestInput($method = 'POST', $key, $defaultValue = NULL, $type = self::STRING, $options = NULL){

		if(in_array($method, ['POST', 'GET', 'REQUEST']) && $key !== NULL && $key != ''){
			$value = NULL;
			
			switch ($method) {
				case 'POST':
					if(isset($_POST[$key])){
						$value = $_POST[$key];
					}
					break;
				
				case 'GET';
					if(isset($_GET[$key])){
						$value = $_GET[$key];
					}
					break;

				case 'REQUEST';
					if(isset($_REQUEST[$key])){
						$value = $_REQUEST[$key];
					}
					break;
			}

			if($value === NULL || $value == ''){
				return $defaultValue;
			} else {


				if ($type == self::INT) {
					return intval($value);
				} else {

					//self::STRING
					if($options !== NULL && is_array($options)){

						if(in_array('SANITIZE', $options)){
							$options[] = 'TRIM';
							$options[] = 'STRIP_TAGS';
							$options[] = 'ESCAPE';
							$options[] = 'EMPTY_UNSAFE';
							$options[] = 'REPLACE_ENCODED_INJECTION';
						}

						// TRIM
						if(in_array('TRIM', $options)){
							$value = trim($value);
						}

						// uppercase
						if(in_array('UCASE', $options)){
							$value = strtoupper($value);
						}

						// lowercase
						if(in_array('LCASE', $options)){
							$value = strtolower($value);
						}

						// escape
						if(in_array('ESCAPE', $options)){

						}


						// Encoded Injection ---------------------------------------------------------------

						if(in_array('REPLACE_ENCODED_INJECTION', $options)){
														
							
							$patterns = array(
									// HTML Entities
									// &gt;
									// &lt ;script&gt ;
									'/\&[a-z0-9]+\s*;/i',

									// Hex encoding --------------------------------------------------------
									// %5A%d4
									'/%[0-9a-f]{2}/i', //TODO ver se tem mais caracteres

									// Hex Encoding / Hexadecimal Encoding
									// &#x8A ;  &#33;
									'/&#x?[0-9a-f]+\s*;/i',


									// UTF8 ENCODING -------------------------------------------------------
									// \u0074
									// \u0069
									'/\\\u[0-9a-f]{1,4}/i', //TODO ver se tem é numerico ou alfanumerico o codigo utf8

									
									'/\\\x[0-9a-f]{1,4}/i',

									// MYSQL HEXSTRING
									'/0x[0-9a-f]+;?/i'

								);
							
							$replacement = '';
							$value = preg_replace($patterns, $replacement, $value);

							// hex string (MySQL)
							// 0x5061756c;

						}


						if(in_array('EMPTY_UNSAFE', $options)){//TODO TEST
							// apaga a string se tiver palavras maliciosas

							$valueUppercase = strtoupper($value);
							foreach (self::$hotWords as $hotWord){

								if(strpos($valueUppercase, $hotWord) !== FALSE){
									$value = '';
									break;
								}
							}

						}

						// strip tags
						if(in_array('STRIP_TAGS', $options)){
							$value = strip_tags($value);
						}
						
					}

					return $value;
				}
			}
		}

		return NULL;
	}

	public static function getInput($key, $defaultValue = NULL, $type = self::STRING, $options = NULL){
		return self::requestInput('GET', $key, $defaultValue, $type, $options);
	}

	public static function postInput($key, $defaultValue = NULL, $type = self::STRING, $options = NULL){
		return self::requestInput('POST', $key, $defaultValue, $type, $options);
	}

	public static function input($key, $defaultValue = NULL, $type = self::STRING, $options = NULL){//TODO test
		return self::requestInput('REQUEST', $key, $defaultValue, $type, $options);
	}

}

?>

